<?php 

define("BORDER",20);
define("SHADOW",15);
define("OFFSET",10);

header('Content-type: image/jpeg');

// Pobiera obraz
$filename = $_GET['photo'];

// Tworzy oznaczenie i nazwę pliku po modyfikacji
$str = strtok($filename,".");
$newfile = $str . "mod.jpg";

// Odczytuje zmodyfikowany plik, jeśli taki istnieje
if (file_exists($newfile)) {
    readfile($newfile);

} else { // Tworzy plik

   $im=imagecreatefromjpeg($filename);

   if (!$im) exit("not a JPEG image");

   // Oblicza wymiary nowego obrazu i rysuje go
   $width=imagesx($im);
   $height=imagesy($im);

   $newwidth=$width+(2*BORDER);
   $newheight=$height+(2*BORDER);
   $newimage=imagecreatetruecolor($newwidth,$newheight);

   // Tworzy prostokąt wypełniony kolorem
   $white = imagecolorallocate($newimage, 255, 255, 255);
   imagefilledrectangle($newimage,0,0,$newwidth,$newheight,$white);

   // Kopiuje stary obraz do nowego obrazu
   imagecopy($newimage,$im,BORDER,BORDER,0,0,$width,$height);

   // Dodaje czarną obwódkę
   $black = imagecolorallocate($newimage, 127, 127, 127);
   imagerectangle($newimage, 0,0,$newwidth-1, $newheight-1,$black);

   // Dodaje cień
   // Tworzy nową kanwę wypełnioną kolorem białym
   $shadowimage = imagecreatetruecolor($newwidth+SHADOW, $newheight+SHADOW);
   imagefilledrectangle($shadowimage, 0, 0, $newwidth+SHADOW, $newheight+SHADOW, $white);

   //Otwiera plik z szablonem cienia i kopiuje jego zawartość do nowego obszaru roboczego
   $shadowimg = imagecreatefromjpeg("workingshadow.jpg");
   imagecopyresized($shadowimage,$shadowimg,5,5,0,0,$newwidth+OFFSET,$newheight+OFFSET, imagesx($shadowimg),imagesy($shadowimg));

   // Kopiuje zdjęcie z dodanym obramowaniem
   imagecopy($shadowimage,$newimage,5,5,0,0,$newwidth,$newheight);

   // Obraca obraz
   imagejpeg($shadowimage);

   // Zapisuje obraz
   imagejpeg($shadowimage,$newfile,100);

   // Nieobowiązkowe
   // czyszczenie pamięci
   imagedestroy($newimage);
   imagedestroy($im);
   imagedestroy($shadowimage);
}
?>
